/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/* This MX kernel lib code was originally contributed by
 * Brice.Goglin@ens-lyon.org (LIP/INRIA/ENS-Lyon) */

static const char __idstring[] = "@(#)$Id: mx_klib.c,v 1.39.2.2 2006/09/05 21:44:08 atchley Exp $";

#include "mx_arch_klib.h"
#include "mx_arch.h"
#include "mx_instance.h"
#include "mx_malloc.h"
#include "mx_klib.h"

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_extensions.h"
#include "mx__internals.h"

/* all these seem useless for now ? */
int mx_klib_initialized = 0;

mx_klib_mutex_t mx_klib_lock; /* useless ? */
mx_klib_mutex_t Mx_rcache_lock;
/* may be replaced by thread.c inclusion */

int
mx_init_klib(void)
{
  if (!mx_klib_initialized) {
    mx_klib_mutex_init(&mx_klib_lock);
    mx_klib_mutex_init(&Mx_rcache_lock);
    mx_klib_initialized = 1;
  }
  return 0;
}

void
mx_finalize_klib(void)
{
  if (mx_klib_initialized) {
    mx_klib_mutex_destroy(&mx_klib_lock);
    mx_klib_mutex_destroy(&Mx_rcache_lock);
    mx_klib_initialized = 0;
  }
}

int
mx_klib_open(mx_endpt_state_t **es)
{
  *es = NULL;
  return 0;
}

/* 
 * An NULL es means that the external module only open
 * a board but not endpoint.
 * This leads to mx_endptless_ioctl.
 */

int
mx_klib_set_endpoint(mx_endpt_state_t **retes, uint32_t unit,
		     uint32_t endpoint, uint32_t *session_id)
{
  mx_endpt_state_t *es;
  int status;
  
  es = mx_kmalloc(sizeof(*es), MX_MZERO|MX_WAITOK);
  if (es == 0)
    return ENOMEM;
  
  es->privileged = 0;
  es->is_kernel = 1;

  /* set to -1.  Can't set to a real pid, as the process opening
     the endpoint could disappear */
  es->opener.pid = -1;
  /* TODO */
  sprintf(es->opener.comm, "mx_klib");
    
  status = mx_common_open(unit, endpoint, es, 0);
  if (status != 0) {
    mx_kfree(es);
    return (status);
  }
  *session_id = es->session_id;
  *retes = es;
  
  MX_DEBUG_PRINT (MX_DEBUG_OPENCLOSE, 
		  ("Board %d, endpoint %d opened\n", 
		   unit, endpoint));

  return 0;
}

int
mx_klib_close(mx_endpt_state_t *es)
{
  if (es != NULL ) {
    mx_common_close(es);
    mx_kfree(es);
  }
  return 0;
}

int
mx_klib_ioctl(mx_endpt_state_t *es, int cmd, void *p, size_t size)
{
  int retval;
  if ( es == NULL ) {
    retval = mx_endptless_ioctl(cmd, (mx_uaddr_t) p, 0, 1);
  } else {
    retval = mx_common_ioctl(es, (uint32_t) cmd, (mx_uaddr_t) p);
    if (retval == ENOTTY) {
      retval = mx_endptless_ioctl((uint32_t) cmd, (mx_uaddr_t) p, 0, 1);
    }
  }
  return retval;
}

int
mx_klib_map(mx_endpt_state_t *es, char **sendq, char **eventq,
	      char **recvq, char **sram, char **zreq)
{
  *sendq = (void*)(uintptr_t) es->sendq.pins[0].va;
  *eventq = (void*)(uintptr_t) es->eventq.pins[0].va;
  *recvq = (void*)(uintptr_t) es->recvq.pins[0].va;
  *sram = es->user_mmapped_sram.addr;
  *zreq = es->user_mmapped_zreq.addr;
  return 0;
}


uintptr_t mx_klib_memory_context(void)
{
  return mx_get_memory_context();
}

mx_klib_symbol(mx__init_api);
mx_klib_symbol(mx_finalize);
mx_klib_symbol(mx_open_endpoint);
mx_klib_symbol(mx_close_endpoint);
mx_klib_symbol(mx_wakeup);
mx_klib_symbol(mx_kisend);
mx_klib_symbol(mx_kissend);
mx_klib_symbol(mx_kirecv);
/* mx_klib_symbol(mx_ibarrier); */
/* mx_klib_symbol(mx_kibcast); */
mx_klib_symbol(mx_cancel);
mx_klib_symbol(mx_forget);
mx_klib_symbol(mx_test);
mx_klib_symbol(mx_wait);
mx_klib_symbol(mx_test_any);
mx_klib_symbol(mx_wait_any);
mx_klib_symbol(mx_ipeek);
mx_klib_symbol(mx_peek);
mx_klib_symbol(mx_iprobe);
mx_klib_symbol(mx_probe);
mx_klib_symbol(mx_ibuffered);
/* mx_klib_symbol(mx_buffered); */
/* mx_klib_symbol(mx_kcreate_rdma_window); */
/* mx_klib_symbol(mx_destroy_rdma_window); */
/* mx_klib_symbol(mx_krdma_read); */
/* mx_klib_symbol(mx_krdma_write); */
mx_klib_symbol(mx_get_info);
mx_klib_symbol(mx_hostname_to_nic_id);
mx_klib_symbol(mx_board_number_to_nic_id);
mx_klib_symbol(mx_nic_id_to_hostname);
mx_klib_symbol(mx_nic_id_to_board_number);
mx_klib_symbol(mx_iconnect);
mx_klib_symbol(mx_connect);
mx_klib_symbol(mx_disconnect);
mx_klib_symbol(mx_decompose_endpoint_addr);
mx_klib_symbol(mx_get_endpoint_addr);
mx_klib_symbol(mx_set_endpoint_addr_context);
mx_klib_symbol(mx_get_endpoint_addr_context);
mx_klib_symbol(mx_context);
mx_klib_symbol(mx_register_unexp_callback);
mx_klib_symbol(mx_register_unexp_handler);
mx_klib_symbol(mx_disable_progression);
mx_klib_symbol(mx_reenable_progression);
mx_klib_symbol(mx_progress);
mx_klib_symbol(mx_strerror);
mx_klib_symbol(mx_strstatus);
mx_klib_symbol(mx_klib_memory_context);
mx_klib_symbol(mx_set_request_timeout);
